<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Certificate</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
        }

        .certificate-container {
            background-image:url("./assets/images/certificate-img.png");
            /* background-position: center; */
            background-repeat: no-repeat;
            background-size: contain;
            padding:100px;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center; /* Horizontal center */
            align-items: center;     /* Vertical center */
            text-align: center;
            font-family: 'DejaVu Sans', sans-serif; /* for mPDF compatibility */
        }

        .certificate-content {
            /* Optional: set max width */
            max-width: 100%;
        }
        .row {
            display: block;
            clear: both;
            width: 100%;
            margin-top:30px;
        }

        .col-md-6 {
            float: left;
            width: 50%;
            box-sizing: border-box;
            /* padding: 10px; */
        }

        .clearfix::after {
            content: "";
            display: table;
            clear: both;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <div class="certificate-content">
            <h1>ATTESTATION DE RECONNAISSANCE</h1>
            <h4 style="padding-bottom:0px;font-weight:normal;">Décerné à l’agent de santé à base communautaire</h4>
            <h1 style="font-size:50px;margin-top:0px;"><?php echo e($agent->nom); ?> <?php echo e($agent->prenom); ?></h1>
            <!-- <div style="border: none; border-top: 1px solid red;margin:0 100px;margin-bottom:50px;"></div> -->
            <p style="text-align:justify;margin:0 30px;padding:10px;border:1px solid red;">Pour son engagement dans la mise en œuvre réussie des activités de santé communautaire dans le village de <b><?php echo e($agent->village_->libelle); ?></b> du district sanitaire de <b><?php echo e($agent->district_->libelle); ?></b> depuis <?php echo e(\Carbon\Carbon::parse($agent->date_recrutement)->locale('fr')->translatedFormat('j F Y')); ?>.</p>
            <p>fait à Ouagadougou le <?php echo e(\Carbon\Carbon::parse($date)->locale('fr')->translatedFormat('j F Y')); ?></p>
            <p><small>ID Certificat : <?php echo e($certificateId); ?></small></p>
            <div class="row clearfix">
                <div class="col-md-6">
                    <p style="margin-bottom:0px;">Sécrétaire Général du Ministère<br/>de la Santé</p>
                    <img src="<?php echo e(asset('assets/images/signature.png')); ?>" alt="" width="30%">
                </div>
                <div class="col-md-6">
                    <p style="margin-bottom:0px;">Directeur de la Direction de la<br/>Santé Communautaire</p>
                    <img src="<?php echo e(asset('assets/images/signature.png')); ?>" alt="" width="30%">
                </div>
            </div>
            <img src="data:image/png;base64, <?php echo e(base64_encode($qr)); ?>" alt="QR Code">
        </div>
    </div>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/asbc-directory/resources/views/certificate.blade.php ENDPATH**/ ?>