<?php

namespace App\Http\Middleware;

use Illuminate\Contracts\Auth\Factory as Auth;
use Closure;

class ApiAuthenticate
{
    /**
     * The authentication guard factory instance.
     *
     * @var \Illuminate\Contracts\Auth\Factory
     */
    protected $auth;

    /**
     * Create a new middleware instance.
     *
     * @param  \Illuminate\Contracts\Auth\Factory  $auth
     * @return void
     */
    public function __construct(Auth $auth)
    {
        $this->auth = $auth;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        // if ($this->auth->guard('token')->guest()) {
            // return response()->json(['error' => 'Unauthorized'], 401);
        // }
        
        $response = $this->auth->guard('token')->user();
        switch($response){
            case '0' : return response()->json(['error' => 'Unauthorized'], 401); break;
            case '1' : return response()->json(['error' => 'Method unauthorized'], 401); break;
            case '2' : return response()->json(['error' => 'Unauthenticated'], 401); break;
            case '3' : return response()->json(['error' => 'Error'], 401); break;
        }

        return $next($request);
    }
}